﻿// Constant buffer layouts
#pragma once

namespace RTCam {

	// Model properties (updated per object)
	struct ModelCBuffer {
		DirectX::XMFLOAT4X4A WorldViewProjection;
		DirectX::XMFLOAT4X4A PrevWorldViewProjection;
		DirectX::XMFLOAT4X4A InvWorldViewProjection;
		DirectX::XMFLOAT4X4A Normal;
		DirectX::XMFLOAT3A Emission;
	};

	// Camera properties (updated per frame)
	struct CameraCBuffer {
		DirectX::XMFLOAT4X4A ViewProjection;
		float NearClip;
		float FarClip;
		float ProjectionA;
		float ProjectionB;
		// Film/image properties
		float FilmWidth;
		float FilmHeight;
		int ImageWidth;
		int ImageHeight;
		// Lens properties
		float FocalLength;
		float FocalDistance;
		float LensDistance;
		float FNumber;
		float ExposureModifier;
		// Film grain
		float Time;
		float GrainSpeed;
		float NoiseStrength;
		// Long exposure blend factor
		float LongExposureBlendFactor;
		// Aberration properties
		float SphericalAberrationFactor;
	};

} // end namespace